/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign.commands.sign;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import kz.digital.taxtech.documents.multisign.KalkanProvHolder;
import kz.digital.taxtech.documents.multisign.SelectedKeyHolder;
import kz.digital.taxtech.documents.multisign.commands.ACommand;
import kz.digital.taxtech.documents.multisign.commands.BasicsFailure;
import kz.digital.taxtech.documents.multisign.commands.CommonException;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SelectKeyRequest;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SigningResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.ViewableCert;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.openssl.PEMWriter;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.XMLUtil;
import kz.gov.pki.provider.utils.model.CmsSigningParams;
import kz.gov.pki.provider.utils.model.RawSigningParams;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.SigningParams;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.provider.utils.model.XmlSigningParams;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignCommand
extends ACommand<SigningResponse> {
    public static final String COMMAND = "sign";

    @Override
    public SigningResponse doCommand(JSONObject command, String origin) throws CommonException {
        String[] data;
        XmlSigningParams signingParams;
        if (SelectedKeyHolder.getInstance().getViewableCert() == null || !origin.equals(SelectedKeyHolder.getInstance().getSelectKeyRequest().getOrigin())) {
            throw new CommonException(BasicsFailure.KEY_NOT_SELECTED);
        }
        Date current = new Date();
        X509Certificate certificate = SelectedKeyHolder.getInstance().getViewableCert().getCertificate();
        if (current.after(certificate.getNotAfter()) || current.before(certificate.getNotBefore())) {
            throw new CommonException(BasicsFailure.CERTIFICATE_EXPIRED);
        }
        JSONObject jsonArgs = command.getJSONObject("args");
        String format = jsonArgs.getString("format");
        JSONObject jsonSigningParams = jsonArgs.optJSONObject("signingParams");
        boolean decode = jsonSigningParams != null && jsonSigningParams.optBoolean("decode", false);
        switch (format) {
            case "xml": {
                signingParams = XmlSigningParams.builder().build();
                break;
            }
            case "cms": {
                boolean encapsulate = jsonSigningParams.optBoolean("encapsulate", true);
                boolean digested = jsonSigningParams.optBoolean("digested", false);
                JSONObject tsaProfile = jsonSigningParams.optJSONObject("tsaProfile");
                boolean withTSA = false;
                if (tsaProfile != null) {
                    withTSA = tsaProfile.optBoolean("withTsp", false);
                }
                signingParams = CmsSigningParams.builder().decode(decode).encapsulate(encapsulate).digested(digested).tsaProfile(withTSA ? new TSAProfile() : null).build();
                break;
            }
            case "raw": {
                signingParams = RawSigningParams.builder().decode(decode).build();
                break;
            }
            default: {
                throw new CommonException(BasicsFailure.INVALID_SIGNING_PARAMS);
            }
        }
        JSONArray jsonArray = jsonArgs.optJSONArray("data");
        if (jsonArray != null) {
            data = new String[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                data[i] = jsonArray.getString(i);
            }
        } else {
            data = new String[]{jsonArgs.getString("data")};
        }
        try {
            return this.sign((SigningParams)signingParams, data);
        }
        catch (ProviderUtilException pe) {
            throw new CommonException(pe.getCode().name(), pe.getMessage(), pe);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e3) {
            throw new CommonException(BasicsFailure.SIGNING_FAILURE, (Throwable)e3);
        }
        catch (Exception e4) {
            throw new CommonException(BasicsFailure.SIGNING_FAILURE, (Throwable)e4);
        }
    }

    private SigningResponse sign(SigningParams signingParams, String[] signData) throws CommonException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, ProviderUtilException, IOException {
        SelectKeyRequest request = SelectedKeyHolder.getInstance().getSelectKeyRequest();
        ViewableCert viewableCert = SelectedKeyHolder.getInstance().getViewableCert();
        SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)request.getKeyStore(), (String)viewableCert.getAlias(), (char[])request.getPassword());
        if (signingParams instanceof CmsSigningParams) {
            CmsSigningParams params = (CmsSigningParams)signingParams;
            byte[] data = params.isDecode() ? Base64.getDecoder().decode(signData[0]) : signData[0].getBytes(StandardCharsets.UTF_8);
            CMSSignedData cms = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])data, (boolean)params.isEncapsulate(), (boolean)params.isDigested(), (Provider)KalkanProvHolder.getInstance().getProvider());
            if (params.getTsaProfile() != null) {
                cms = CMSUtil.applyCAdEST((CMSSignedData)cms, (SigningEntity)signingEntity, (TSAProfile)params.getTsaProfile(), (Provider)KalkanProvHolder.getInstance().getProvider());
            }
            StringWriter stringWriter = new StringWriter();
            try (PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);){
                pemWriter.writeObject((Object)cms);
                pemWriter.flush();
                SigningResponse<String> signingResponse = new SigningResponse<String>(stringWriter.toString());
                return signingResponse;
            }
        }
        if (signingParams instanceof XmlSigningParams) {
            String[] results = new String[signData.length];
            for (int i = 0; i < signData.length; ++i) {
                results[i] = XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)signData[i], (Provider)KalkanProvHolder.getInstance().getProvider());
            }
            return new SigningResponse<String[]>(results);
        }
        if (signingParams instanceof RawSigningParams) {
            byte[] signedData;
            RawSigningParams params = (RawSigningParams)signingParams;
            byte[] data = params.isDecode() ? Base64.getDecoder().decode(signData[0]) : signData[0].getBytes(StandardCharsets.UTF_8);
            String keyAlg = signingEntity.getKey().getAlgorithm();
            keyAlg = "RSA".equals(keyAlg) ? "SHA256withRSA" : keyAlg;
            Signature signature = Signature.getInstance(keyAlg, KalkanProvHolder.getInstance().getProvider());
            try {
                signature.initSign(signingEntity.getKey());
                signature.update(data);
                signedData = signature.sign();
            }
            catch (InvalidKeyException | SignatureException e) {
                throw new CommonException(BasicsFailure.SIGNING_FAILURE);
            }
            return new SigningResponse<String>(Base64.getEncoder().encodeToString(signedData));
        }
        throw new CommonException(BasicsFailure.INVALID_SIGNING_PARAMS);
    }
}

