/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign.commands.selectkey;

import java.security.cert.X509Certificate;

public final class ViewableCert
implements Comparable<ViewableCert> {
    private final X509Certificate certificate;
    private final String commonName;
    private final String alias;
    private final boolean revoked;
    private final boolean disabled;

    @Override
    public int compareTo(ViewableCert o) {
        return this.getCertificate().getNotBefore().compareTo(o.getCertificate().getNotBefore());
    }

    ViewableCert(X509Certificate certificate, String commonName, String alias, boolean revoked, boolean disabled) {
        this.certificate = certificate;
        this.commonName = commonName;
        this.alias = alias;
        this.revoked = revoked;
        this.disabled = disabled;
    }

    public static ViewableCertBuilder builder() {
        return new ViewableCertBuilder();
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewableCert)) {
            return false;
        }
        ViewableCert other = (ViewableCert)o;
        if (this.isRevoked() != other.isRevoked()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        X509Certificate this$certificate = this.getCertificate();
        X509Certificate other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        String this$commonName = this.getCommonName();
        String other$commonName = other.getCommonName();
        if (this$commonName == null ? other$commonName != null : !this$commonName.equals(other$commonName)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        return !(this$alias != null ? !this$alias.equals(other$alias) : other$alias != null);
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.isRevoked() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        X509Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        String $commonName = this.getCommonName();
        result = result * 59 + ($commonName == null ? 43 : $commonName.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    public String toString() {
        return "ViewableCert(certificate=" + this.getCertificate() + ", commonName=" + this.getCommonName() + ", alias=" + this.getAlias() + ", revoked=" + this.isRevoked() + ", disabled=" + this.isDisabled() + ")";
    }

    public static class ViewableCertBuilder {
        private X509Certificate certificate;
        private String commonName;
        private String alias;
        private boolean revoked;
        private boolean disabled;

        ViewableCertBuilder() {
        }

        public ViewableCertBuilder certificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public ViewableCertBuilder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public ViewableCertBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ViewableCertBuilder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        public ViewableCertBuilder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public ViewableCert build() {
            return new ViewableCert(this.certificate, this.commonName, this.alias, this.revoked, this.disabled);
        }

        public String toString() {
            return "ViewableCert.ViewableCertBuilder(certificate=" + this.certificate + ", commonName=" + this.commonName + ", alias=" + this.alias + ", revoked=" + this.revoked + ", disabled=" + this.disabled + ")";
        }
    }
}

