/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign.commands.selectkey;

import java.io.File;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.StringConverter;
import kz.digital.taxtech.documents.multisign.LoggerHolder;
import kz.digital.taxtech.documents.multisign.commands.selectkey.AbstractStage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.AllowedStorage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.FileExtensions;
import kz.digital.taxtech.documents.multisign.commands.selectkey.FileStorage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SelectKeyRequest;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SmartcardStorage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.StorageResponse;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.asn1.x509.KeyPurposeId;
import kz.gov.pki.kalkan.pcsc.PCSCUtils;
import kz.gov.pki.kalkan.pcsc.Smartcard;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.KeyStoreUtil;

public class StorageStage
extends AbstractStage {
    private static final String NCA_USERS_OID_BRANCH = "1.2.398.3.3.4.2";
    private KeyStore keyStore;
    private char[] password;
    private final ObservableList<AllowedStorage> actualAllowedStorages = FXCollections.observableArrayList();
    private final List<AllowedStorage> allowedStorages = new ArrayList<AllowedStorage>();
    private final SelectKeyRequest request;
    private ComboBox<AllowedStorage> storageComboBox;
    private ComboBox<Smartcard> terminalNameComboBox;
    private TextField pathTextField;
    private Button openFileBtn;
    private PasswordField passwordField;
    private String container;
    protected Provider provider = Security.getProvider("KALKAN");
    protected Label actionNameLabel;

    public StorageStage(SelectKeyRequest request, Locale locale) {
        super(locale);
        this.request = request;
        this.addActionTypeLabels();
        this.addStorageControls();
        this.addPasswordControls();
        this.headerLabel.setText(MessageFormat.format(this.localise("ui.label.origin"), request.getOrigin()));
        if (request.getSignerParams().getExtKeyUsages().contains(KeyPurposeId.id_kp_clientAuth.getId())) {
            this.actionNameLabel.setText(this.localise("ui.text.authentication"));
        } else {
            this.actionNameLabel.setText(this.localise("ui.text.signing"));
        }
        this.addButtons();
        this.openFileBtn.setOnAction(e -> {
            File file = this.chooseFile(this.pathTextField.getText(), FileExtensions.PKCS12);
            if (file != null) {
                this.pathTextField.setText(file.getPath());
                this.pathTextField.setTooltip(new Tooltip(file.getPath()));
            }
        });
        this.submitButton.setText(this.localise("ui.button.open"));
        BooleanBinding booleanBinding = this.passwordField.textProperty().isEmpty().or((ObservableBooleanValue)this.storageComboBox.disabledProperty());
        this.submitButton.disableProperty().bind((ObservableValue)booleanBinding);
        this.submitButton.setOnAction(e -> {
            AllowedStorage storage = (AllowedStorage)this.storageComboBox.getSelectionModel().getSelectedItem();
            this.container = storage.getStorage().isToken() ? ((Smartcard)this.terminalNameComboBox.getSelectionModel().getSelectedItem()).getTerminalName() : this.pathTextField.getText();
            try {
                this.password = this.passwordField.getText().toCharArray();
                if (request.getSignerParams().getExtKeyUsages().stream().anyMatch(o -> o.startsWith(NCA_USERS_OID_BRANCH))) {
                    CharBuffer passSeq = CharBuffer.wrap(this.password);
                    Matcher matcher = Pattern.compile("^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#$^+=!*()@%&_-]).{8,32}$").matcher(passSeq);
                    if (!matcher.matches()) {
                        this.showAlertWithHeader(Alert.AlertType.ERROR, this.localise("ui.text.error.inner_password_pattern_mismatch"));
                        return;
                    }
                }
                if (storage.getStorage() == Storage.KZIDCARD) {
                    KeyStoreUtil.getKeyStore((Storage)storage.getStorage(), (String)this.container, (char[])this.password, (Provider)this.provider);
                }
                this.keyStore = KeyStoreUtil.getKeyStore((Storage)storage.getStorage(), (String)this.container, (char[])this.password, (Provider)this.provider);
                Map aliasToEntry = KeyStoreUtil.getKeyStoreEntries((KeyStore)this.keyStore, (char[])this.password);
                if (aliasToEntry.isEmpty()) {
                    this.showAlertWithHeader(Alert.AlertType.ERROR, this.localise("ui.text.error.empty_storage"));
                    return;
                }
                this.response = StorageResponse.builder().aliasToEntry(aliasToEntry).build();
                this.stage.close();
            }
            catch (ProviderUtilException e1) {
                LoggerHolder.getInstance().getLogService().log(1, "Error", (Throwable)e1);
                this.showAlertWithMessage(Alert.AlertType.ERROR, this.localise("ui.text.error.keystore_not_loaded"), e1.getMessage());
            }
            catch (Exception e1) {
                this.showAlertWithMessage(Alert.AlertType.ERROR, this.localise("ui.text.error.keystore_not_loaded"), e1.toString());
            }
        });
    }

    private void addStorageControls() {
        Label keystoreLabel = new Label(this.localise("ui.label.keystore_type"));
        this.gridPane.add((Node)keystoreLabel, 0, this.lastControlIndex);
        this.storageComboBox = new ComboBox(this.actualAllowedStorages);
        Button refreshButton = new Button("", (Node)this.loadImageFromResource("/imgs/refresh.png"));
        refreshButton.setTooltip(new Tooltip(this.localise("ui.button.refresh")));
        refreshButton.setOnAction(e -> this.loadSlotList());
        HBox storageHBox = new HBox();
        storageHBox.setSpacing(5.0);
        storageHBox.getChildren().addAll((Object[])new Node[]{this.storageComboBox, refreshButton});
        this.gridPane.add((Node)storageHBox, 1, this.lastControlIndex);
        ++this.lastControlIndex;
        Label locationLabel = new Label(this.localise("ui.label.keystore_location"));
        locationLabel.setWrapText(true);
        this.gridPane.add((Node)locationLabel, 0, this.lastControlIndex);
        this.terminalNameComboBox = new ComboBox();
        HBox.setHgrow(this.terminalNameComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.terminalNameComboBox, (Priority)Priority.ALWAYS);
        this.gridPane.add(this.terminalNameComboBox, 1, this.lastControlIndex);
        this.pathTextField = new TextField();
        this.pathTextField.setEditable(false);
        this.openFileBtn = new Button("", (Node)this.loadImageFromResource("/imgs/open.png"));
        HBox pathHBox = new HBox();
        pathHBox.setSpacing(5.0);
        pathHBox.getChildren().addAll((Object[])new Node[]{this.pathTextField, this.openFileBtn});
        this.gridPane.add((Node)pathHBox, 1, this.lastControlIndex);
        this.storageComboBox.setConverter((StringConverter)new StringConverter<AllowedStorage>(){

            public String toString(AllowedStorage object) {
                return StorageStage.this.localiseStorage(object);
            }

            public AllowedStorage fromString(String string) {
                return null;
            }
        });
        this.terminalNameComboBox.setConverter((StringConverter)new StringConverter<Smartcard>(){

            public String toString(Smartcard object) {
                return object.getTerminalName();
            }

            public Smartcard fromString(String string) {
                return null;
            }
        });
        this.storageComboBox.setCellFactory(e -> new ListCell<AllowedStorage>(){

            protected void updateItem(AllowedStorage item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(StorageStage.this.localiseStorage(item));
                } else {
                    this.setText("");
                }
            }
        });
        this.storageComboBox.valueProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue != null) {
                boolean isToken = newValue.getStorage().isToken();
                pathHBox.setVisible(!isToken);
                this.terminalNameComboBox.setVisible(isToken);
                this.terminalNameComboBox.getItems().clear();
                if (newValue instanceof SmartcardStorage) {
                    SmartcardStorage smartcardStorage = (SmartcardStorage)newValue;
                    this.terminalNameComboBox.getItems().addAll(smartcardStorage.getSmartcards());
                    if (!smartcardStorage.getSmartcards().isEmpty()) {
                        this.terminalNameComboBox.setValue(this.terminalNameComboBox.getItems().get(0));
                        this.container = ((Smartcard)this.terminalNameComboBox.getItems().get(0)).getTerminalName();
                    }
                } else {
                    this.container = this.pathTextField.getText();
                }
            } else {
                this.terminalNameComboBox.getItems().clear();
            }
        });
        this.allowedStorages.addAll(this.request.getAllowedStorages());
        this.loadSlotList();
        ++this.lastControlIndex;
    }

    private void loadSlotList() {
        List smartcards = PCSCUtils.loadSlotList();
        for (AllowedStorage allowedStorage : this.allowedStorages) {
            if (allowedStorage instanceof SmartcardStorage) {
                SmartcardStorage smartcardStorage = (SmartcardStorage)allowedStorage;
                List<Smartcard> foundSmartcards = smartcards.stream().filter(e -> e.getType().equals(smartcardStorage.getStorage().getName())).collect(Collectors.toList());
                if (foundSmartcards.isEmpty()) {
                    this.actualAllowedStorages.remove((Object)smartcardStorage);
                    continue;
                }
                if (!this.actualAllowedStorages.contains((Object)smartcardStorage)) {
                    this.actualAllowedStorages.add((Object)smartcardStorage);
                }
                smartcardStorage.setSmartcards(foundSmartcards);
                continue;
            }
            if (this.actualAllowedStorages.contains((Object)allowedStorage)) continue;
            this.actualAllowedStorages.add((Object)allowedStorage);
            if (this.pathTextField.getText().isEmpty()) {
                String path = ((FileStorage)allowedStorage).getPath();
                this.pathTextField.setText(path);
            }
            if (this.pathTextField.getText().isEmpty()) continue;
            this.pathTextField.setTooltip(new Tooltip(this.pathTextField.getText()));
        }
        if (this.storageComboBox.getItems().isEmpty()) {
            this.storageComboBox.setDisable(true);
        } else {
            this.storageComboBox.setDisable(false);
            this.storageComboBox.getSelectionModel().selectFirst();
        }
    }

    private String localiseStorage(AllowedStorage object) {
        return this.localise("ui.text.storage." + object.getStorage().name().toLowerCase());
    }

    private void addPasswordControls() {
        Label passwordLabel = new Label(this.localise("ui.label.password"));
        this.gridPane.add((Node)passwordLabel, 0, this.lastControlIndex);
        this.passwordField = new PasswordField();
        Button showPasswordButton = new Button("", (Node)this.loadImageFromResource("/imgs/eye.png"));
        showPasswordButton.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            this.passwordField.setPromptText(this.passwordField.getText());
            this.passwordField.clear();
        });
        showPasswordButton.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
            this.passwordField.setText(this.passwordField.getPromptText());
            this.passwordField.setPromptText("");
        });
        HBox passwordHBox = new HBox();
        passwordHBox.setSpacing(5.0);
        passwordHBox.getChildren().addAll((Object[])new Node[]{this.passwordField, showPasswordButton});
        this.gridPane.add((Node)passwordHBox, 1, this.lastControlIndex);
        ++this.lastControlIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImageView loadImageFromResource(String imageFilePath) {
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(imageFilePath);){
            ImageView imageView = new ImageView(new Image(resourceAsStream));
            return imageView;
        }
        catch (Exception e) {
            return new ImageView();
        }
    }

    public File chooseFile(String initialFilePath, FileExtensions fileExtension) {
        FileChooser fileChooser = new FileChooser();
        if (fileExtension != null && !fileExtension.equals((Object)FileExtensions.ALL)) {
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(fileExtension.getDesc(), fileExtension.getExts());
            fileChooser.getExtensionFilters().add((Object)extFilter);
        }
        if (initialFilePath != null && !initialFilePath.trim().isEmpty()) {
            File initialDir = new File(initialFilePath);
            if (!initialDir.isDirectory()) {
                initialDir = initialDir.getParentFile();
            }
            if (Files.exists(initialDir.toPath(), new LinkOption[0])) {
                fileChooser.setInitialDirectory(initialDir);
            }
        }
        fileChooser.setTitle(this.localise("ui.window.title.choose_file"));
        Stage stage = this.createTransparentStage();
        File f = fileChooser.showOpenDialog((Window)stage);
        stage.close();
        return f;
    }

    private Stage createTransparentStage() {
        Stage stage = new Stage();
        stage.setWidth(10.0);
        stage.setHeight(10.0);
        stage.setAlwaysOnTop(true);
        this.addIcon();
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.centerOnScreen();
        stage.show();
        return stage;
    }

    protected void addActionTypeLabels() {
        Label actionTypeLabel = new Label(this.localise("ui.label.action"));
        this.gridPane.add((Node)actionTypeLabel, 0, this.lastControlIndex);
        this.actionNameLabel = new Label();
        this.actionNameLabel.setTextFill((Paint)Color.RED);
        this.actionNameLabel.setId("actionNameLabel");
        this.gridPane.add((Node)this.actionNameLabel, 1, this.lastControlIndex);
        ++this.lastControlIndex;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public char[] getPassword() {
        return this.password;
    }
}

