/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign.commands.selectkey;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import javafx.application.Platform;
import kz.digital.taxtech.documents.multisign.SelectedKeyHolder;
import kz.digital.taxtech.documents.multisign.commands.ACommand;
import kz.digital.taxtech.documents.multisign.commands.BasicsFailure;
import kz.digital.taxtech.documents.multisign.commands.CommonException;
import kz.digital.taxtech.documents.multisign.commands.SelectKeyResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.AllowedStorage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.EmptyResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.FileStorage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.KeystoreResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.KeystoreStage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.LayerResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SelectKeyRequest;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SignerParams;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SmartcardStorage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.StorageResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.StorageStage;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class SelectKeyCommand
extends ACommand<SelectKeyResponse> {
    private static final CertificateFactory certificateFactory;
    public static final String COMMAND = "selectKey";

    @Override
    public SelectKeyResponse doCommand(JSONObject command, String origin) throws CommonException {
        LayerResponse ret;
        ArrayList<X509Certificate> chain;
        JSONObject jsonArgs = command.getJSONObject("args");
        List<AllowedStorage> allowedStorages = this.obtainAllStorages();
        String localeArg = jsonArgs.optString("locale", "kk");
        Locale locale = new Locale(localeArg);
        SelectKeyRequest selectKeyRequest = new SelectKeyRequest();
        selectKeyRequest.setOrigin(origin);
        selectKeyRequest.setAllowedStorages(allowedStorages);
        JSONObject jsonSignerParams = jsonArgs.getJSONObject("signerParams");
        JSONArray jsonChain = jsonSignerParams.optJSONArray("chain");
        if (jsonChain == null) {
            chain = KeyStoreUtil.getDefaultCACerts();
        } else {
            ArrayList<X509Certificate> tmp = new ArrayList<X509Certificate>();
            for (Object e : jsonChain) {
                try {
                    tmp.add(SelectKeyCommand.getCertificateFromString((String)e));
                }
                catch (CertificateException e1) {
                    throw new CommonException(BasicsFailure.CERTIFICATE_PARSING_FAILURE, (Throwable)e1);
                }
            }
            chain = tmp;
        }
        HashSet<String> extKeyUsages = new HashSet<String>();
        jsonSignerParams.getJSONArray("extKeyUsageOids").iterator().forEachRemaining(o -> extKeyUsages.add((String)o));
        String iin = jsonSignerParams.optString("iin");
        String bin = jsonSignerParams.optString("bin");
        String serialNumber = jsonSignerParams.optString("serialNumber");
        SignerParams signerParams = new SignerParams(extKeyUsages, chain, iin, bin, serialNumber);
        selectKeyRequest.setSignerParams(signerParams);
        FutureTask<LayerResponse> query = new FutureTask<LayerResponse>(() -> {
            StorageStage stage = new StorageStage(selectKeyRequest, locale);
            stage.showStage();
            LayerResponse response = stage.getResponse();
            if (response instanceof StorageResponse) {
                StorageResponse storageResponse = (StorageResponse)response;
                selectKeyRequest.setAliasToEntry(storageResponse.getAliasToEntry());
                selectKeyRequest.setKeyStore(stage.getKeyStore());
                selectKeyRequest.setPassword(stage.getPassword());
                KeystoreStage ksStage = new KeystoreStage(selectKeyRequest, locale);
                ksStage.showStage();
                return ksStage.getResponse();
            }
            return response;
        });
        Platform.runLater(query);
        try {
            ret = query.get();
        }
        catch (InterruptedException | ExecutionException e2) {
            throw new CommonException(BasicsFailure.SIGNING_FAILURE, (Throwable)e2);
        }
        if (ret instanceof EmptyResponse) {
            throw new CommonException(BasicsFailure.KEY_NOT_SELECTED);
        }
        SelectedKeyHolder.getInstance().setData(selectKeyRequest, ((KeystoreResponse)ret).getViewableCert());
        return new SelectKeyResponse(((KeystoreResponse)ret).getViewableCert().getCertificate().getSubjectDN().getName());
    }

    private List<AllowedStorage> obtainAllStorages() {
        return Arrays.stream(Storage.values()).map(e -> {
            if (e.isToken()) {
                return new SmartcardStorage((Storage)e);
            }
            return new FileStorage((Storage)e);
        }).collect(Collectors.toList());
    }

    public static X509Certificate getCertificateFromString(String base64Cert) throws CertificateException {
        base64Cert = base64Cert.replace("\n", "").replace("\r", "").trim();
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(base64Cert)));
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "KALKAN");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

