/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign.commands.selectkey;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import kz.digital.taxtech.documents.multisign.LoggerHolder;
import kz.digital.taxtech.documents.multisign.commands.selectkey.AbstractStage;
import kz.digital.taxtech.documents.multisign.commands.selectkey.ExceptionUtils;
import kz.digital.taxtech.documents.multisign.commands.selectkey.KeystoreResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.LayerRequest;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SelectKeyRequest;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SignerParams;
import kz.digital.taxtech.documents.multisign.commands.selectkey.ViewableCert;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.KeyPurposeId;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.OCSPCode;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.PKIXUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.gov.pki.reference.KeyUsageType;

public class KeystoreStage
extends AbstractStage {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private final SelectKeyRequest request;
    private final IntegerProperty correspondingKeysCount = new SimpleIntegerProperty(0);

    public KeystoreStage(LayerRequest layerRequest, Locale locale) {
        super(locale);
        this.request = (SelectKeyRequest)layerRequest;
        ObservableList certs = FXCollections.observableArrayList((Collection)this.request.getAliasToEntry().entrySet().stream().filter(m -> m.getValue() != null && ((KeyStoreEntry)m.getValue()).getX509Certificate() != null).map(e -> {
            boolean revoked;
            boolean disabled;
            SignerParams signerParams;
            X509Certificate cert;
            block13: {
                PKIXUtil pkixUtil;
                cert = ((KeyStoreEntry)e.getValue()).getX509Certificate();
                signerParams = this.request.getSignerParams();
                Set<String> extKeyUsages = signerParams.getExtKeyUsages();
                disabled = false;
                revoked = false;
                try {
                    HashSet<String> currentExtKeyUsages;
                    HashSet<String> hashSet = currentExtKeyUsages = cert.getExtendedKeyUsage() == null ? new HashSet<String>() : new HashSet<String>(cert.getExtendedKeyUsage());
                    if (this.isObsoleteAuthType(extKeyUsages, cert)) {
                        currentExtKeyUsages.add(KeyPurposeId.id_kp_clientAuth.getId());
                    }
                    if (!currentExtKeyUsages.containsAll(extKeyUsages)) {
                        disabled = true;
                    }
                }
                catch (CertificateParsingException ex) {
                    throw new IllegalStateException(ex);
                }
                List<X509Certificate> chain = signerParams.getChain();
                if (!chain.isEmpty()) {
                    pkixUtil = new PKIXUtil(cert, chain).allowExpired();
                    try {
                        pkixUtil.validate();
                    }
                    catch (ProviderUtilException ex) {
                        LoggerHolder.getInstance().getLogService().log(1, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0446\u0435\u043f\u043e\u0447\u043a\u0438", (Throwable)ex);
                        disabled = true;
                    }
                }
                if (!chain.isEmpty()) {
                    pkixUtil = new PKIXUtil(cert, chain).withOCSP().allowExpired();
                    try {
                        pkixUtil.validate();
                    }
                    catch (Exception ex) {
                        LoggerHolder.getInstance().getLogService().log(1, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0446\u0435\u043f\u043e\u0447\u043a\u0438", (Throwable)ex);
                        Throwable cause = ExceptionUtils.getRootCause(ex);
                        if (!(cause instanceof KalkanException) || ((KalkanException)cause).getErrorCode() != OCSPCode.STATUS_REVOKED) break block13;
                        revoked = true;
                        disabled = true;
                    }
                }
            }
            String iin = signerParams.getIin();
            X509Name x509Name = X509Util.getSubjectDN((X509Certificate)cert);
            String certIin = X509Util.getRdn((X509Name)x509Name, (DERObjectIdentifier)X509Name.SERIALNUMBER, (int)0);
            if (!(iin.isEmpty() || certIin != null && iin.equals(certIin.replace("IIN", "")))) {
                disabled = true;
            }
            String bin = signerParams.getBin();
            String certBin = X509Util.getRdn((X509Name)x509Name, (DERObjectIdentifier)X509Name.OU, (int)0);
            if (!(bin.isEmpty() || certBin != null && bin.equals(certBin.replace("BIN", "")))) {
                disabled = true;
            }
            String serialNumber = signerParams.getSerialNumber();
            String certSerialNumber = Hex.encodeStr((byte[])cert.getSerialNumber().toByteArray());
            if (!serialNumber.isEmpty() && !serialNumber.toLowerCase().equals(certSerialNumber)) {
                disabled = true;
            }
            return ViewableCert.builder().certificate(cert).alias((String)e.getKey()).commonName(((KeyStoreEntry)e.getValue()).getSubjectCn()).revoked(revoked).disabled(disabled).build();
        }).collect(Collectors.toList()));
        Collections.sort(certs);
        ListView listView = new ListView(FXCollections.observableList((List)certs));
        this.gridPane.add((Node)listView, 0, this.lastControlIndex, 2, 1);
        ++this.lastControlIndex;
        listView.setCellFactory(param -> new KeystoreEntriesListCell());
        this.headerLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.correspondingKeysCount.get() > 0) {
                return this.localise("ui.label.choose_key");
            }
            return this.localise("ui.label.corresponding_key_not_found");
        }, (Observable[])new Observable[]{this.correspondingKeysCount}));
        this.addButtons();
        this.submitButton.setText(this.localise("ui.button.sign"));
        this.submitButton.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)listView.getSelectionModel().getSelectedItems()));
        this.submitButton.setOnAction(e -> {
            if (listView.getItems().isEmpty()) {
                return;
            }
            ViewableCert selectedItem = (ViewableCert)listView.getSelectionModel().getSelectedItem();
            if (selectedItem == null || selectedItem.isDisabled()) {
                return;
            }
            X509Certificate cert = selectedItem.getCertificate();
            if (cert != null) {
                if (this.isNotWithinValidityPeriod(cert)) {
                    this.showAlertWithHeader(Alert.AlertType.ERROR, this.localise("ui.text.error.cert_expired"));
                    return;
                }
                this.response = new KeystoreResponse(selectedItem);
                this.stage.close();
            }
        });
    }

    private boolean isNotWithinValidityPeriod(X509Certificate cert) {
        Date now = new Date();
        Date notBefore = cert.getNotBefore();
        Date notAfter = cert.getNotAfter();
        return now.before(notBefore) || now.after(notAfter);
    }

    private boolean isObsoleteAuthType(Set<String> extKeyUsages, X509Certificate cert) {
        String sigAlgOID = cert.getSigAlgOID();
        return extKeyUsages.contains(KeyPurposeId.id_kp_clientAuth.getId()) && (sigAlgOID.equals(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId()) || sigAlgOID.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId()) && X509Util.containsKeyUsage((X509Certificate)cert, (KeyUsageType)KeyUsageType.KEY_ENCIPHERMENT));
    }

    private class KeystoreEntriesListCell
    extends ListCell<ViewableCert> {
        private KeystoreEntriesListCell() {
        }

        protected void updateItem(ViewableCert item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                X509Certificate cert = item.getCertificate();
                Label commonName = new Label(KeystoreStage.this.localise("ui.label.cert.common_name") + item.getCommonName());
                Label validityPeriod = new Label(KeystoreStage.this.localise("ui.label.cert.validity_period") + dateFormat.format(cert.getNotBefore()) + " - " + dateFormat.format(cert.getNotAfter()));
                if (KeystoreStage.this.isNotWithinValidityPeriod(cert)) {
                    validityPeriod.setTextFill((Paint)Color.DARKRED);
                }
                VBox vbox = new VBox();
                vbox.setSpacing(1.0);
                vbox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                vbox.getChildren().addAll((Object[])new Node[]{commonName});
                X509Name x509Name = X509Util.getSubjectDN((X509Certificate)cert);
                String bin = X509Util.getRdn((X509Name)x509Name, (DERObjectIdentifier)X509Name.OU, (int)0);
                if (bin != null) {
                    Label binLabel = new Label(KeystoreStage.this.localise("ui.label.cert.bin") + bin);
                    Label organizationName = new Label(KeystoreStage.this.localise("ui.label.cert.organization_name") + X509Util.getRdn((X509Name)x509Name, (DERObjectIdentifier)X509Name.O, (int)0));
                    vbox.getChildren().addAll((Object[])new Node[]{organizationName, binLabel});
                }
                vbox.getChildren().add((Object)validityPeriod);
                if (item.isRevoked()) {
                    Label revoked = new Label(KeystoreStage.this.localise("ui.label.cert.revoked"));
                    revoked.setTextFill((Paint)Color.DARKRED);
                    vbox.getChildren().addAll((Object[])new Node[]{revoked});
                }
                this.setGraphic((Node)vbox);
                this.setDisable(item.isDisabled());
                if (!this.isDisabled()) {
                    KeystoreStage.this.correspondingKeysCount.set(KeystoreStage.this.correspondingKeysCount.get() + 1);
                }
            }
        }
    }
}

