/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign.commands.selectkey;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import kz.digital.taxtech.documents.multisign.LoggerHolder;
import kz.digital.taxtech.documents.multisign.commands.selectkey.EmptyResponse;
import kz.digital.taxtech.documents.multisign.commands.selectkey.LayerResponse;

public abstract class AbstractStage {
    private final Locale locale;
    protected Stage stage;
    protected GridPane gridPane;
    protected Button submitButton;
    protected Button cancelButton;
    protected int lastControlIndex;
    protected LayerResponse response;
    protected Label headerLabel;

    protected AbstractStage(Locale locale) {
        this.locale = locale;
        this.stage = this.createStage();
        this.addPaneControls();
    }

    public void showStage() {
        this.stage.showAndWait();
    }

    private void addPaneControls() {
        this.headerLabel = new Label("Base Header");
        this.headerLabel.setId("headerLabel");
        this.headerLabel.setWrapText(true);
        this.headerLabel.setTextAlignment(TextAlignment.CENTER);
        this.gridPane.add((Node)this.headerLabel, 0, 0, 2, 1);
        GridPane.setHalignment((Node)this.headerLabel, (HPos)HPos.CENTER);
        GridPane.setMargin((Node)this.headerLabel, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        ++this.lastControlIndex;
    }

    protected void addButtons() {
        this.submitButton = new Button(this.localise("ui.button.ok"));
        this.submitButton.setDefaultButton(true);
        this.submitButton.setPrefWidth(100.0);
        this.cancelButton = new Button(this.localise("ui.button.cancel"));
        this.cancelButton.setPrefWidth(100.0);
        this.cancelButton.setCancelButton(true);
        this.cancelButton.getStyleClass().add((Object)"custom-cancel-button");
        this.cancelButton.setOnAction(e -> this.stage.fireEvent((Event)new WindowEvent((Window)this.stage, WindowEvent.WINDOW_CLOSE_REQUEST)));
        HBox buttonsHBox = new HBox(20.0, new Node[]{this.submitButton, this.cancelButton});
        buttonsHBox.setAlignment(Pos.CENTER);
        this.gridPane.add((Node)buttonsHBox, 0, this.lastControlIndex, 2, 1);
        GridPane.setMargin((Node)buttonsHBox, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(10.0, 20.0, 10.0, 20.0));
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        ColumnConstraints columnOneConstraints = new ColumnConstraints(150.0, 150.0, Double.MAX_VALUE);
        columnOneConstraints.setHalignment(HPos.LEFT);
        ColumnConstraints columnTwoConstrains = new ColumnConstraints(200.0, 250.0, Double.MAX_VALUE);
        columnTwoConstrains.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnOneConstraints, columnTwoConstrains});
        return gridPane;
    }

    private Stage createStage() {
        Stage stage = new Stage();
        stage.setAlwaysOnTop(true);
        this.addIcon();
        stage.setTitle("NCALayer");
        this.gridPane = this.createGridPane();
        Scene scene = new Scene((Parent)this.gridPane);
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/stylesheet.css").toExternalForm());
        stage.setScene(scene);
        stage.setResizable(false);
        stage.centerOnScreen();
        stage.setOnCloseRequest(e -> {
            this.response = new EmptyResponse();
        });
        return stage;
    }

    protected void addIcon() {
        try {
            URL url = AbstractStage.class.getResource("/icon.png");
            if (url != null) {
                InputStream is = url.openStream();
                this.stage.getIcons().add((Object)new Image(is));
            }
        }
        catch (IOException e) {
            LoggerHolder.getInstance().getLogService().log(1, "Error loading icon", (Throwable)e);
        }
    }

    protected String localise(String key) {
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/Basics", this.locale);
        if (bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        return key;
    }

    private void showAlert(Alert.AlertType alertType, String title, String header, String message) {
        Alert alert = new Alert(alertType);
        alert.setHeaderText(header);
        alert.setTitle(title);
        alert.setContentText(message);
        alert.initOwner((Window)this.stage);
        alert.show();
    }

    protected void showAlertWithHeader(Alert.AlertType alertType, String header) {
        this.showAlert(alertType, "NCALayer", header, null);
    }

    protected void showAlertWithMessage(Alert.AlertType alertType, String header, String message) {
        this.showAlert(alertType, "NCALayer", header, message);
    }

    public LayerResponse getResponse() {
        return this.response;
    }
}

