/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.digital.taxtech.documents.multisign.commands.BaseResponce;

public class SelectKeyResponse
extends BaseResponce {
    private static final Pattern iinPattern = Pattern.compile(".*SERIALNUMBER=IIN(\\d{12}).*");
    private static final Pattern binPattern = Pattern.compile(".*OU=BIN(\\d{12}).*");
    private final String subjectDN;
    private final String iin;
    private final String bin;

    public SelectKeyResponse(String subjectDN) {
        this.subjectDN = subjectDN;
        Matcher iinmatcher = iinPattern.matcher(subjectDN);
        this.iin = iinmatcher.find() ? iinmatcher.group(1) : null;
        Matcher binmatcher = binPattern.matcher(subjectDN);
        this.bin = binmatcher.find() ? binmatcher.group(1) : null;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public String getIin() {
        return this.iin;
    }

    public String getBin() {
        return this.bin;
    }
}

