/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.digital.taxtech.documents.multisign.LoggerHolder;
import kz.digital.taxtech.documents.multisign.commands.ACommand;
import kz.digital.taxtech.documents.multisign.commands.BaseResponce;
import kz.digital.taxtech.documents.multisign.commands.CommonException;
import kz.digital.taxtech.documents.multisign.commands.reset.ResetCommand;
import kz.digital.taxtech.documents.multisign.commands.selectedkeyinfo.SelectedKeyInfoCommand;
import kz.digital.taxtech.documents.multisign.commands.selectkey.SelectKeyCommand;
import kz.digital.taxtech.documents.multisign.commands.sign.SignCommand;
import kz.digital.taxtech.documents.multisign.commands.versiongetter.VersionGetter;
import kz.gov.pki.osgi.layer.api.ModuleService;
import org.json.JSONObject;

public class NCAModule
implements ModuleService {
    private final Map<String, ACommand<? extends BaseResponce>> commands = new HashMap<String, ACommand<? extends BaseResponce>>();

    public NCAModule() {
        this.commands.put("version", new VersionGetter());
        this.commands.put("selectKey", new SelectKeyCommand());
        this.commands.put("sign", new SignCommand());
        this.commands.put("selectedKeyInfo", new SelectedKeyInfoCommand());
        this.commands.put("reset", new ResetCommand());
    }

    public String process(String s, String s1) {
        BaseResponce responce;
        JSONObject command = new JSONObject(s);
        String cmd = command.getString("method");
        JSONObject headers = new JSONObject(s1);
        String origin = headers.optString("origin", "UNDEFINED");
        Pattern pattern = Pattern.compile("(https?://[^/]*)/*.*");
        Matcher matcher = pattern.matcher(origin);
        origin = matcher.find() ? matcher.group(1) : "UNDEFINED";
        try {
            responce = this.commands.get(cmd).doCommand(command, origin);
        }
        catch (CommonException e) {
            LoggerHolder.getInstance().getLogService().log(1, "Error", (Throwable)e);
            responce = new BaseResponce(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            LoggerHolder.getInstance().getLogService().log(1, "Error", (Throwable)e);
            responce = new BaseResponce("TECH_ERROR", e.getMessage());
        }
        return JSONObject.wrap((Object)responce).toString();
    }
}

