/*
 * Decompiled with CFR 0.152.
 */
package kz.digital.taxtech.documents.multisign;

import java.util.Hashtable;
import kz.digital.taxtech.documents.multisign.KalkanProvHolder;
import kz.digital.taxtech.documents.multisign.LoggerHolder;
import kz.digital.taxtech.documents.multisign.NCAModule;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.gov.pki.osgi.layer.api.NCALayerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Launcher
implements BundleActivator {
    private LogService logService = null;
    private NCALayerService ncaLayerService;

    public void start(BundleContext context) throws Exception {
        NCAModule moduleService = new NCAModule();
        this.getLogService(context);
        this.getNCALayerService(context);
        this.registerService(context, moduleService);
    }

    public void stop(BundleContext context) {
    }

    private void registerService(BundleContext context, NCAModule moduleService) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("module", "kz.digital.taxtech.documents.multisign.NCAModule");
        context.registerService(ModuleService.class, (Object)moduleService, props);
    }

    private void getLogService(BundleContext context) throws InvalidSyntaxException {
        String logServiceFilter = "(objectClass=" + LogService.class.getName() + ")";
        ServiceTracker logService_tracker = new ServiceTracker(context, context.createFilter(logServiceFilter), null);
        logService_tracker.open();
        this.logService = (LogService)logService_tracker.getService();
        if (this.logService == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    this.logService = (LogService)logService_tracker.getService(e.getServiceReference());
                    LoggerHolder.initLogger(this.logService);
                }
            }, logServiceFilter);
        } else {
            LoggerHolder.initLogger(this.logService);
        }
    }

    private void getNCALayerService(BundleContext context) throws InvalidSyntaxException {
        String filter = "(objectClass=" + NCALayerService.class.getName() + ")";
        ServiceTracker ncaLayerService_tracker = new ServiceTracker(context, context.createFilter(filter), null);
        ncaLayerService_tracker.open();
        this.ncaLayerService = (NCALayerService)ncaLayerService_tracker.getService();
        if (this.ncaLayerService == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    this.ncaLayerService = (NCALayerService)ncaLayerService_tracker.getService(e.getServiceReference());
                    KalkanProvHolder.initProvider(this.ncaLayerService.getProvider());
                }
            }, filter);
        } else {
            KalkanProvHolder.initProvider(this.ncaLayerService.getProvider());
        }
    }
}

